/******************************************************************************
 * (C) Copyright 1999 by Agilent Technologies GmbH. All rights reserved.      *
 ******************************************************************************/

/* ---------------------------------------------------------------
 * File: xobserve.h
 *       Observer functions
 * -----------------------------------------------------------------*/

#ifndef XOBSERVER_H_INCLUDED
#define XOBSERVER_H_INCLUDED

#include <xobsdefs.h>


#ifdef __cplusplus
extern "C" {
#endif

/* -----------------------------------------------------------------------
 * Observer Functions
 * -----------------------------------------------------------------------
 */

/****************************************  
 *** Prog/Read functions
 ****************************************/  

/* Read mask + errors from card to host */
CLI bx_errtype EXPORT BestXObsRead( /* @obsread */
  bx_handletype   handle
);

/* Write mask from host to card */
CLI bx_errtype EXPORT BestXObsProg( /* @obsprog */
  bx_handletype   handle
);

/****************************************  
 *** Error and status functions 
 ****************************************/  

/* Return accumulated error of a rule (host only) */
CLI bx_errtype EXPORT BestXObsAccuErrorGet(  /* @obsaccuerrorget */
  bx_handletype  handle,
  bx_obsruletype rule,                   
  bx_int32 *accuerr       /* #RETURN "%d" */
);

/* Return first error of a rule (host only) */
CLI bx_errtype EXPORT BestXObsFirstErrorGet(  /* @obsfirsterrorget */
  bx_handletype  handle,
  bx_obsruletype rule,                   
  bx_int32 *firsterr       /* #RETURN "%d" */
);

/* Return textual error summay (host only) */
CLI bx_errtype EXPORT BestXObsStatusGet( /* @obsstatusget */
  bx_handletype   handle,
  bx_charptrtype  *statustext    /* #RETURN "%s" */
);

/* Return textual rule description */
CLI bx_errtype EXPORT BestXObsRuleStringGet( /* @obsrulestringget */
  bx_handletype   handle,
  bx_obsruletype  rule,  
  bx_charptrtype  *ruletext    /* #RETURN "\"%s\"" */
);

/****************************************  
 *** Masking functions
 ****************************************/  

/* Set mask of a rule (host only) */
CLI bx_errtype EXPORT BestXObsMaskSet( /* @obsmaskset */
  bx_handletype   handle,
  bx_obsruletype rule,
  bx_int32 mask
);

/* Return mask of a rule (host only) */
CLI bx_errtype EXPORT BestXObsMaskGet( /* @obsmaskget */
  bx_handletype   handle,
  bx_obsruletype rule,
  bx_int32 *mask                       /* #RETURN "%lu" */
);

/****************************************  
 *** Helper functions 
 ****************************************/  
  
/* Convert bitposition -> rule (host only) */
CLI bx_errtype EXPORT BestXObsRuleGet(  /* @obsruleget */
  bx_handletype handle,
  bx_int32       bitpos,
  bx_obsruletype *rule  /* #RETURN "%lu" */
);

/* Convert rule -> bitposition (host only) */
CLI bx_errtype EXPORT BestXObsBitPosGet(  /* @obsbitposget */
  bx_handletype handle,
  bx_obsruletype rule,  
  bx_int32       *bitpos  /* #RETURN "%lu" */
);

/* Set mask + errors to default (host only) */
/* not documented */
CLI bx_errtype EXPORT BestXObsDefaultSet( /* @obsdefaultset */
  bx_handletype   handle
);

#ifndef SWIG
/* not documented */
CLI bx_errtype EXPORT BestXObsRuleInfoGet( /* @obsruleinfoget */
  bx_handletype   handle,
  bx_obsruletype  rule,  
  bx_int32        type,
  bx_charptrtype  *text    /* #RETURN "\"%s\"\n" */
);
/* not documented */
bx_errtype EXPORT BestXObsErrorGet(
  bx_handletype  handle,
  bx_obsruletype rule,                   
  bx_int32 *accuerr,
  bx_int32 *firsterr                 
);
#endif

#ifdef __cplusplus
}
#endif

#endif

